components.widgets.module('switcher',
    [],
    () => {
        return {
            vue: true,
            name: 'gx-switcher',
            template: '#gx-switcher',
            props: {
                title: {
                    type: String,
                    default: ''
                },
                value: {
                    type: Boolean,
                    default: false
                },
                onState: {
                    type: String,
                    default: `<span class="fa fa-check"></span>`
                },
                offState: {
                    type: String,
                    default: `<span class="fa fa-times"></span>`
                }
            },
            data() {
                return {
                    input: this.value
                }
            },
            watch: {
                input(val) {
                    this.$emit('input', val);
                }
            },
            methods: {
                clickSwitcher() {
                    this.input = !this.input;
                }
            },
            init: done => done()
        }
    });